unit Testfrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FormSize, StdCtrls, Buttons, Mask;

type
  TMainForm = class(TFormSizer)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MaskEdit1: TMaskEdit;
    MaskEdit2: TMaskEdit;
    MaskEdit3: TMaskEdit;
    MaskEdit4: TMaskEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure SaveValues;
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
   MaxWidth:=320;       {Max Width Allowed}
   MaxHeight:=250;      {Max Height Allowed}
   MinWidth:=100;        {Min Width Allowed}
   MinHeight:=100;       {Min Height Allowed}
   SaveValues;
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
   MinWidth:=StrToIntDef(MaskEdit1.Text, 100);
   MinHeight:=StrToIntDef(MaskEdit2.Text, 100);
   MaxWidth:=StrToIntDef(MaskEdit3.Text, 100);
   MaxHeight:=StrToIntDef(MaskEdit4.Text, 100);
   if MaxWidth<100 then MaxWidth:=100;
   if MaxHeight<100 then MaxHeight:=100;
   if MinWidth>MaxWidth then MinWidth:=MaxWidth;
   if MinHeight>MaxHeight then MinHeight:=MaxHeight;
   SaveValues;
end;

procedure TMainForm.SaveValues;
begin
   MaskEdit1.Text:=IntToStr(MinWidth);
   MaskEdit2.Text:=IntToStr(MinHeight);
   MaskEdit3.Text:=IntToStr(MaxWidth);
   MaskEdit4.Text:=IntToStr(MaxHeight);
end;

procedure TMainForm.BitBtn2Click(Sender: TObject);
begin
   RestoreSize;
   SaveValues;
end;

end.
